TITLE   'Laplace Equation in 3D'			       	           { 3d222.pde }
SELECT     errlim=1e-3     spectral_colors	
COORDINATES     cartesian3	
VARIABLES     U		
DEFINITIONS                                     		
   L=1.0     d0=2.0     q=1e-10          	
   eps0=8.85e-12     c=1/(4*pi*eps0)
   U_ex=-q*c/sqrt( x^2+(y+d0)^2+ z^2)+ q*c/sqrt( x^2+(y-d0)^2+ z^2)	
        +q*c/sqrt( (x+d0)^2+y^2+ z^2)		{ Exact solution }
   Ex=-dx( U)     Ey=-dy( U)      Ez=-dz( U)     	{ Field components }
   div_xy=dx( Ex)+ dy( Ey)
   E=-grad(U)     Em=magnitude(E)
EQUATIONS
   div( grad( U))=0
EXTRUSION     						{ Limiting surfaces }
   surface 'bottom' z=-L
   surface 'top' z=L					
BOUNDARIES
   surface 'bottom'  value( U)=U_ex
   surface 'top' value( U)=U_ex
region 'domain'
start(-L,-L) 	value( U)=U_ex		{ Outer boundary on base plane }
   line to (L,-L) to (L,L) to (-L,L) close
PLOTS
   grid(x,z) on y=0
   contour( U) painted on z=0     contour( U_ex) painted on z=0
   contour( U- U_ex) on z=0     	{ Deviation from exact U }
   contour( U- U_ex) on z=0 zoom(-0.5,-0.5,  1.0,1.0)
   contour( U) painted on z=0.3     contour( U_ex) painted on z=0.3
   contour( U) painted on z=1.0     contour( U_ex) painted on z=1.0	
   contour( U- U_ex) on z=1.0
END


